<?php
// Enable error reporting for debugging (should be disabled in production)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();
require 'server/config.db.php';
require '../index/PHPMailer/src/Exception.php';
require '../index/PHPMailer/src/PHPMailer.php';
require '../index/PHPMailer/src/SMTP.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

$accountNumber = $_POST['accountNumber'];
$amount = $_POST['amount'];
$description = $_POST['description'];
$user_id = $_SESSION['user_id'];

// Fetch user balance
$stmt = $pdo->prepare("SELECT balance FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$user = $stmt->fetch();

if ($user['balance'] < $amount) {
    echo 'Insufficient funds';
    exit;
}

// Deduct amount from sender
$stmt = $pdo->prepare("UPDATE users SET balance = balance - ? WHERE id = ?");
$stmt->execute([$amount, $user_id]);

// Add amount to receiver
$stmt = $pdo->prepare("UPDATE users SET balance = balance + ? WHERE account_number = ?");
$stmt->execute([$amount, $accountNumber]);

// Fetch receiver details
$stmt = $pdo->prepare("SELECT id, email, full_name FROM users WHERE account_number = ?");
$stmt->execute([$accountNumber]);
$receiver = $stmt->fetch();

// Check if receiver exists
if (!$receiver) {
    echo 'Receiver not found';
    exit;
}

// Save transaction details for sender (debit)
$stmt = $pdo->prepare("INSERT INTO transactions (sender_id, receiver_id, amount, description, transaction_type) VALUES (?, ?, ?, ?, 'debit')");
$stmt->execute([$user_id, $receiver['id'], $amount, $description]);

// Save transaction details for receiver (credit)
$stmt = $pdo->prepare("INSERT INTO transactions (sender_id, receiver_id, amount, description, transaction_type) VALUES (?, ?, ?, ?, 'credit')");
$stmt->execute([$user_id, $receiver['id'], $amount, $description]);

// Fetch sender details
$stmt = $pdo->prepare("SELECT email, full_name FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$sender = $stmt->fetch();

// Prepare the email template
function getEmailBody($full_name, $message) {
    return '
    <html>
    <head>
        <style>
            body {
                font-family: Arial, sans-serif;
                color: #333;
                line-height: 1.6;
            }
            .container {
                width: 100%;
                max-width: 600px;
                margin: 0 auto;
                padding: 20px;
                background: #f4f4f4;
                border: 1px solid #ddd;
                border-radius: 5px;
            }
            .header {
                text-align: center;
                padding-bottom: 20px;
            }
            .header img {
                width: 60px;
            }
            .content {
                padding: 20px;
                background: #fff;
                border-radius: 5px;
                box-shadow: 0 0 10px rgba(0,0,0,0.1);
            }
            .content h2 {
                color: #0056b3;
            }
            .footer {
                text-align: center;
                padding-top: 20px;
                font-size: 0.9em;
                color: #777;
            }
            .footer a {
                color: #0056b3;
                text-decoration: none;
            }
        </style>
    </head>
    <body>
        <div class="container">
            <div class="header">
                <img src="https://swiftheart.uk/swift/logo.png" alt="Swifftess Logo">
            </div>
            <div class="content">
                <h2>Hello ' . htmlspecialchars($full_name) . ',</h2>
                <p>' . nl2br(htmlspecialchars($message)) . '</p>
            </div>
            <div class="footer">
                <p>&copy; ' . date("Y") . ' Swifttess. All rights reserved.</p>
            </div>
        </div>
    </body>
    </html>';
}

// Send email notifications
$mail = new PHPMailer(true);

try {
    // Server settings
    $mail->isSMTP();
    $mail->Host = 'mail.swifttess.com'; // Set the SMTP server to send through
    $mail->SMTPAuth = true;
    $mail->Username = 'no-reply@west-libertygroup.com'; // SMTP username
    $mail->Password = 'whodeybreathe'; // SMTP password
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
    $mail->Port = 587;

    // Sender email
    $subject = "Transaction Alert";

    // Email to sender (debit alert)
    $mail->setFrom('no-reply@west-libertygroup.com', 'Swiftheart Transaction Alert');
    $mail->addAddress($sender['email'], $sender['full_name']);
    $sender_message = "You have successfully sent \$$amount to account number $accountNumber.\nDescription: $description";
    $mail->isHTML(true);
    $mail->Subject = $subject;
    $mail->Body = getEmailBody($sender['full_name'], $sender_message);
    $mail->send();
    
    // Email to receiver (credit alert)
        $mail->clearAddresses();
        $mail->addAddress($receiver['email'], $receiver['full_name']);
        $receiver_message = "You have received \$$amount from $sender[full_name].\nDescription: $description";
        $mail->Body = getEmailBody($receiver['full_name'], $receiver_message);
        $mail->send();


// Prepare the receipt HTML
    $message = '
    <div class="container">
        <div class="header">
            <img src="http://swiftheart.uk/swift/logo.png" alt="Swifftess Logo">
        </div>
        <div class="content">
            <h2>Transaction Receipt</h2>
            <p><strong>Sender:</strong> ' . htmlspecialchars($sender['full_name']) . '</p>
            <p><strong>Receiver:</strong> ' . htmlspecialchars($receiver['full_name']) . '</p>
            <p><strong>Amount:</strong> $' . htmlspecialchars($amount) . '</p>
            <p><strong>Description:</strong> ' . htmlspecialchars($description) . '</p>
            <p><strong>Date:</strong> ' . date("Y-m-d H:i:s") . '</p>
        </div>
        <div class="footer">
            <p>&copy; ' . date("Y") . ' BLX Growth services. All rights reserved.</p>
        </div>
        <div class="watermark">west</div>
    </div>';
} catch (Exception $e) {
    $message = "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
}
?>

<?php 
// Enable error reporting for debugging purposes
error_reporting(E_ALL);
ini_set('display_errors', 1);
require 'server/config.db.php';
require 'server/login-check.php';
require 'server/header.php';
?>
  
<?php
// Query to get the settings table (default currency and symbol)
$query = "SELECT currency, symbol FROM settings LIMIT 1";
$stmt = $pdo->prepare($query);
$stmt->execute();
$settings = $stmt->fetch(PDO::FETCH_ASSOC);

// Store the values from the settings table
$defaultCurrency = $settings['currency']; // e.g., USD, EUR, etc.
$defaultSymbol = $settings['symbol']; // e.g., $, €, ₦, etc.

$query = "SELECT * FROM users WHERE id = :user_id"; // Get VAT, currency, and symbol for the logged-in user
$stmt = $pdo->prepare($query);
$stmt->execute([':user_id' => $_SESSION['user_id']]); // Assuming user_id is stored in the session
$user = $stmt->fetch(PDO::FETCH_ASSOC);

// Get user currency, symbol, and VAT status from the result
$userCurrency = $user['currency'];
$userSymbol = $user['symbol'];
$userBalance = $user['balance'];
$vatStatus = $user['vat'];

// Determine which currency and symbol to use
$currency = !empty($userCurrency) ? $userCurrency : $defaultCurrency;
$symbol = !empty($userSymbol) ? $userSymbol : $defaultSymbol;
?>
    <!DOCTYPE html>
<html lang="en-US" class="js">
    <head>
    <meta charset="utf-8">
    <meta name="author" content="Smart">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="This Credit Union is federally insured by the National Credit Union Administration. We do business in accordance with the Fair Housing Law and Equal opportunity Credit Act.">
    <!-- Fav Icon  -->
    <link rel="shortcut icon" href="../images/favicon.jpg">
    <!-- Page Title  -->
    <title>Transaction Reciept</title>
    <!-- StyleSheets  -->
    <link rel="stylesheet" href="../scss/sweetalert.css">
    <link rel="stylesheet" href="../assets/css/dashlite.css?ver=2.4.0">
    <link id="skin-default" rel="stylesheet" href="../assets/css/theme.css?ver=2.4.0">
     <link rel="stylesheet" type="text/css" href="../assets/css/fontawesome.css"> 
     <link href="../css/toastr.css" rel="stylesheet"/>
     <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
   </head>
    <link rel="stylesheet" href="https://www.jqueryscript.net/demo/jQuery-International-Telephone-Input-With-Flags-Dial-Codes/build/css/intlTelInput.css">
   <script type="text/javascript">
function googleTranslateElementInit() {
  new google.translate.TranslateElement({pageLanguage: 'en', layout: google.translate.TranslateElement.InlineLayout.SIMPLE}, 'google_translate_element');
}
</script>
<script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
    <style>
.goog-te-gadget-simple {
border:none;
}
.goog-te-gadget-simple a {
color:#000;
}
.preloader {
            position: fixed;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background: rgba(255, 255, 255, 0.8);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 9999;
        }
        .preloader img {
            width: 100px; /* Adjust the size of the spinner */
        }
        body {
            overflow: hidden; /* Prevent scrolling while loading */
        }
        body.loaded {
            overflow: auto;
        }
</style>
<style type="text/css">
    .btn-primary{
        background-color: #033d75;
    }
    .btn-secondary{
        background-color: #d13636;
    }
    .btn-secondary:hover{opacity: 0.6;}
    .btn-primary:hover{opacity: 0.6;}
</style>
<body class="nk-body npc-crypto bg-white has-sidebar ">
    
    <div class="nk-app-root">
        <!-- main @s -->
        <div class="nk-main ">
            <?php require 'server/sidebar.php' ?>
            <!-- sidebar @e -->
            <!-- wrap @s -->
            <div class="nk-wrap ">
                <!-- main header @s -->
                <div class="nk-header nk-header-fluid nk-header-fixed is-secondary">
                    <div class="container-fluid">
                        <div class="nk-header-wrap">
                            <div class="nk-menu-trigger d-xl-none ml-n1">
                                <a href="#" class="nk-nav-toggle nk-quick-nav-icon" data-target="sidebarMenu"><em class="icon fas fa-bars"></em></em></a>
                            </div>
                            <div class="nk-header-brand d-xl-none">
                                <a href="#" class="logo-link">
                                    <img class="logo-light logo-img" src="../logo.jpeg" srcset="../logo.jpeg" alt="logo">
                                    <img class="logo-dark logo-img" src="../logo.jpeg" srcset="../logo.jpeg" alt="logo-dark">
                                </a>
                            </div>
                            <div class="nk-header-news d-none d-xl-block">
                                <div class="nk-news-list">
                                    <a class="nk-news-item" href="#">
                                        <div class="nk-news-icon">
                                            <em class="icon fas fa-bars"></em>
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <?php require 'server/dropdown1.php' ?>
                        </div>
                    </div>
                </div>
                <!-- main header @e -->    <div class="nk-content">
    <style>
        body {
            font-family: Arial, sans-serif;
            color: #333;
            line-height: 1.6;
        }
        .container {
            width: 100%;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
            background: #f4f4f4;
            border: 1px solid #ddd;
            border-radius: 5px;
            position: relative;
        }
        .header {
            text-align: center;
            padding-bottom: 20px;
        }
        .header img {
            width: 150px;
        }
        .content {
            padding: 20px;
            background: #fff;
            border-radius: 5px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }
        .content h2 {
            color: #0056b3;
        }
        .footer {
            text-align: center;
            padding-top: 20px;
            font-size: 0.9em;
            color: #777;
        }
        .footer a {
            color: #0056b3;
            text-decoration: none;
        }
        .watermark {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            font-size: 4em;
            color: rgba(0, 0, 0, 0.1);
            pointer-events: none;
            z-index: -1;
        }
    </style>
</head>
<body>
    <?php echo $message; ?>
    
<?php require 'server/footer.php' ?>
</body>
</html>
