<?php
// Include database connection
require 'server/config.db.php';

// Check if request is POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get VAT code from the request body
    $input = json_decode(file_get_contents('php://input'), true);
    $vatCode = $input['vat_code'] ?? '';

    // Validate input
    if (empty($vatCode) || strlen($vatCode) !== 4) {
        echo json_encode(['success' => false, 'message' => 'Invalid VAT code.']);
        exit();
    }

    // Fetch the current user's record (replace with your authentication logic)
    session_start();
    $userId = $_SESSION['user_id'] ?? null; // Assuming `user_id` is stored in session after login

    if (!$userId) {
        echo json_encode(['success' => false, 'message' => 'User not authenticated.']);
        exit();
    }

    try {
        // Check if the VAT code matches the admin VAT
        $query = "SELECT admin_vat, vat FROM users WHERE id = :user_id";
        $stmt = $pdo->prepare($query);
        $stmt->execute([':user_id' => $userId]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$user || $user['vat'] != 1 || $user['admin_vat'] !== $vatCode) {
            echo json_encode(['success' => false, 'message' => 'VAT code mismatch or VAT not enabled.']);
            exit();
        }

        // Update vat_verified to 1
        $updateQuery = "UPDATE users SET vat_verified = 1 WHERE id = :user_id";
        $updateStmt = $pdo->prepare($updateQuery);
        $updateStmt->execute([':user_id' => $userId]);

        // Respond with success and include the redirection URL
        echo json_encode(['success' => true, 'message' => 'VAT code verified successfully.', 'redirect' => 'withdraw.php']);
        exit();
    } catch (PDOException $e) {
        echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request method.']);
}
?>
