<?php 
// Enable error reporting for debugging purposes
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
require 'server/config.db.php';
require 'server/login-check.php';
require 'server/header.php';
?>
<?php
// Query to get the settings table (default currency and symbol)
$query = "SELECT currency, symbol FROM settings LIMIT 1";
$stmt = $pdo->prepare($query);
$stmt->execute();
$settings = $stmt->fetch(PDO::FETCH_ASSOC);

// Store the values from the settings table
$defaultCurrency = $settings['currency']; // e.g., USD, EUR, etc.
$defaultSymbol = $settings['symbol']; // e.g., $, €, ₦, etc.

$query = "SELECT * FROM users WHERE id = :user_id"; // Get VAT, currency, and symbol for the logged-in user
$stmt = $pdo->prepare($query);
$stmt->execute([':user_id' => $_SESSION['user_id']]); // Assuming user_id is stored in the session
$user = $stmt->fetch(PDO::FETCH_ASSOC);

// Get user currency, symbol, and VAT status from the result
$userCurrency = $user['currency'];
$userSymbol = $user['symbol'];
$vatStatus = $user['vat'];
$balance = $user['balance'];

// Determine which currency and symbol to use
$currency = !empty($userCurrency) ? $userCurrency : $defaultCurrency;
$symbol = !empty($userSymbol) ? $userSymbol : $defaultSymbol;
?>
  
    <!DOCTYPE html>
<html lang="en-US" class="js">
    <head>
    <meta charset="utf-8">
    <meta name="author" content="Smart">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="This Credit Union is federally insured by the National Credit Union Administration. We do business in accordance with the Fair Housing Law and Equal opportunity Credit Act.">
    <!-- Fav Icon  -->
    <link rel="shortcut icon" href="./logo.png">
    <!-- Page Title  -->
    <title>Transfer</title>
    <!-- StyleSheets  -->
    <link rel="stylesheet" href="../scss/sweetalert.css">
    <link rel="stylesheet" href="../assets/css/dashlite.css?ver=2.4.0">
    <link id="skin-default" rel="stylesheet" href="../assets/css/theme.css?ver=2.4.0">
     <link rel="stylesheet" type="text/css" href="../assets/css/fontawesome.css"> 
     <link href="../css/toastr.css" rel="stylesheet"/>
     <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
   </head>
    <link rel="stylesheet" href="https://www.jqueryscript.net/demo/jQuery-International-Telephone-Input-With-Flags-Dial-Codes/build/css/intlTelInput.css">
   <script type="text/javascript">
function googleTranslateElementInit() {
  new google.translate.TranslateElement({pageLanguage: 'en', layout: google.translate.TranslateElement.InlineLayout.SIMPLE}, 'google_translate_element');
}
</script>
<script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
<style>
   /* General body styling */
body {
    overflow: auto; /* Allow scrolling */
}

/* Styling for the preloader */
.preloader {
    position: fixed;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    background: rgba(255, 255, 255, 0.8);
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 9999;
}

.preloader img {
    width: 100px; /* Adjust the size of the spinner */
}

/* Loader styling */
.loader {
    border: 4px solid #f3f3f3;
    border-top: 4px solid #3498db;
    border-radius: 50%;
    width: 20px;
    height: 20px;
    animation: spin 2s linear infinite;
    display: none;
    margin-left: 10px;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

/* Valid and error styles */
.valid {
    color: green;
}

.error {
    color: red;
}

/* Hidden elements */
.hidden {
    display: none;
}

/* Button styles */
.btn-primary {
    background-color: #033d75;
}

.btn-secondary {
    background-color: #d13636;
}

.btn-secondary:hover {
    opacity: 0.6;
}

.btn-primary:hover {
    opacity: 0.6;
}
.keypad {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 10px;
            margin: 20px 0;
        }

        .keypad button {
            width: 100%;
            height: 50px;
            font-size: 20px;
        }

        #pinInput {
            pointer-events: none;
            user-select: none;
        }
</style>
<body class="nk-body npc-crypto bg-white has-sidebar ">
    <!-- Modal Structure -->
<div class="modal fade" id="errorModal" tabindex="-1" aria-labelledby="errorModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="errorModalLabel">Notice</h5>
      </div>
      <div class="modal-body text-center">
        Transfer is only Accredited International Accounts Kindly use the 'WITHDRAWAL' for Withdrawal to your Bank Account
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" disabled>Close</button>
      </div>
    </div>
  </div>
</div>

<!-- Include Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>

<script>
  // Show the modal on page load
  document.addEventListener('DOMContentLoaded', function () {
    const modal = new bootstrap.Modal(document.getElementById('errorModal'), {
      backdrop: 'static',
      keyboard: false
    });
    modal.show();
  });
</script>
    
    <div class="nk-app-root">
        <!-- main @s -->
        <div class="nk-main ">
            <?php require 'server/sidebar.php' ?>
            <!-- sidebar @e -->
            <!-- wrap @s -->
            <div class="nk-wrap ">
                <!-- main header @s -->
                <div class="nk-header nk-header-fluid nk-header-fixed is-secondary">
                    <div class="container-fluid">
                        <div class="nk-header-wrap">
                            <div class="nk-menu-trigger d-xl-none ml-n1">
                                <a href="#" class="nk-nav-toggle nk-quick-nav-icon" data-target="sidebarMenu"><em class="icon fas fa-bars"></em></em></a>
                            </div>
                            <div class="nk-header-brand d-xl-none">
                                <a href="#" class="logo-link">
                                    <img class="logo-light logo-img" src="./logo.png" srcset="./logo.png" alt="logo">
                                    <img class="logo-dark logo-img" src="./logo.png" srcset="./logo.png" alt="logo-dark">
                                </a>
                            </div>
                            <div class="nk-header-news d-none d-xl-block">
                                <div class="nk-news-list">
                                    <a class="nk-news-item" href="#">
                                        <div class="nk-news-icon">
                                            <em class="icon fas fa-bars"></em>
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <?php require 'server/dropdown1.php' ?>
                        </div>
                    </div>
                </div>
                
                <!-- main header @e -->    <div class="nk-content">

    <div class="container mt-5">
    <h2 class="mb-4">Send Money</h2>

    <!-- Sub-navigation tabs -->
    <ul class="nav nav-tabs">
        <li class="nav-item">
            <a class="nav-link active" href="#internalTransfer" data-toggle="tab">Internal Transfer</a>
        </li>
        <li class="nav-item">
            <a class="nav-link" href="#universalTransfer" data-toggle="tab">Universal Transfer</a>
        </li>
    </ul>

    <!-- Tab Content -->
    <div class="tab-content mt-3">
        <!-- Internal Transfer Tab -->
        <div class="tab-pane fade show active" id="internalTransfer">
            <!-- Existing Internal Transfer Form -->
            <form id="accountForm">
                <div class="form-group">
                    <label for="accountNumber">Account Number:</label>
                    <input type="text" class="form-control" id="accountNumber" name="accountNumber" maxlength="10" pattern="\d{10}" required>
                    <div id="loader" class="loader"></div>
                    <small id="accountInfo" class="form-text"></small>
                </div>
                <button type="submit" class="btn btn-primary" id="nextButton" disabled>Next</button>
            </form>

            <div id="detailsContainer" class="hidden mt-4">
                <h3>Enter Amount and Description</h3>
                <form id="transactionForm" action="submit_transaction.php" method="post">
                    <input type="hidden" name="accountNumber" id="hiddenAccountNumber">
                    <div class="form-group">
                        <label for="amount">Amount:</label>
                        <input type="number" class="form-control" id="amount" name="amount" required>
                        <small id="userBalance" class="form-text text-success"></small>
                    </div>
                    <div class="form-group">
                        <label for="description">Description:</label>
                        <textarea class="form-control" id="description" name="description" rows="3" required></textarea>
                    </div>
                    <button type="submit" class="btn btn-success">Send</button>
                </form>
            </div>
        </div>
        
        <div id="otpContainer" class="hidden">
    <h3>OTP Verification</h3>
    <input type="text" id="otpInput" class="form-control" maxlength="6" required placeholder="Enter OTP">
    <button class="btn btn-primary" id="verifyOtpButton">Verify OTP</button>
</div>




        <!-- Universal Transfer Tab -->
        <div class="tab-pane fade" id="universalTransfer">
            <h3>Universal Transfer</h3>
            <form id="universalTransferForm" action="universal_transfer.php" method="post">
                <div class="form-group">
                    <label for="amount">Amount:</label>
                    <input type="number" class="form-control" id="amount" name="amount" required>
                </div>
                <button type="submit" class="btn btn-success">Proceed</button>
            </form>
        </div>
    </div>

    <!-- PIN Confirmation Section (Shared for Both Transfers) -->
    <div id="pinContainer" class="hidden mt-4">
            <h3>Enter PIN</h3>
            <input type="password" id="pinInput" class="form-control mb-3" maxlength="4" required readonly>
            <div class="keypad">
                <button type="button" class="btn btn-secondary" onclick="appendPin('1')">1</button>
                <button type="button" class="btn btn-secondary" onclick="appendPin('2')">2</button>
                <button type="button" class="btn btn-secondary" onclick="appendPin('3')">3</button>
                <button type="button" class="btn btn-secondary" onclick="appendPin('4')">4</button>
                <button type="button" class="btn btn-secondary" onclick="appendPin('5')">5</button>
                <button type="button" class="btn btn-secondary" onclick="appendPin('6')">6</button>
                <button type="button" class="btn btn-secondary" onclick="appendPin('7')">7</button>
                <button type="button" class="btn btn-secondary" onclick="appendPin('8')">8</button>
                <button type="button" class="btn btn-secondary" onclick="appendPin('9')">9</button>
                <button type="button" class="btn btn-secondary" onclick="clearPin()">C</button>
                <button type="button" class="btn btn-secondary" onclick="appendPin('0')">0</button>
                <button type="button" class="btn btn-secondary" onclick="deletePin()">←</button>
            </div>
            <button class="btn btn-primary" id="confirmPinButton" disabled>Confirm</button>
        </div>
</div>

<script>
     const accountNumberInput = document.getElementById('accountNumber');
const loader = document.getElementById('loader');
const accountInfo = document.getElementById('accountInfo');
const nextButton = document.getElementById('nextButton');
const detailsContainer = document.getElementById('detailsContainer');
const hiddenAccountNumber = document.getElementById('hiddenAccountNumber');
const userBalance = document.getElementById('userBalance');
const pinContainer = document.getElementById('pinContainer');
const transactionForm = document.getElementById('transactionForm');
const pinInput = document.getElementById('pinInput');
const confirmPinButton = document.getElementById('confirmPinButton');
const otpContainer = document.getElementById('otpContainer');
const otpInput = document.getElementById('otpInput');
const confirmOtpButton = document.getElementById('confirmOtpButton');

accountNumberInput.addEventListener('input', function() {
    const accountNumber = this.value;

    if (accountNumber.length === 10) {
        loader.style.display = 'inline-block';

        fetch('validate_account.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({ accountNumber: accountNumber })
        })
        .then(response => response.json())
        .then(data => {
            loader.style.display = 'none';
            if (data.success) {
                accountInfo.textContent = `✔ ${data.full_name}`;
                accountInfo.classList.remove('error');
                accountInfo.classList.add('valid');
                nextButton.disabled = false;
            } else {
                accountInfo.textContent = '✖ Invalid Account Number';
                accountInfo.classList.remove('valid');
                accountInfo.classList.add('error');
                nextButton.disabled = true;
            }
        })
        .catch(error => {
            loader.style.display = 'none';
            accountInfo.textContent = 'Error validating account';
            accountInfo.classList.remove('valid');
            accountInfo.classList.add('error');
            nextButton.disabled = true;
        });
    } else {
        loader.style.display = 'none';
        accountInfo.textContent = '';
        accountInfo.classList.remove('valid', 'error');
        nextButton.disabled = true;
    }
});

document.getElementById('accountForm').addEventListener('submit', function(event) {
    event.preventDefault();
    hiddenAccountNumber.value = accountNumberInput.value;

    fetch('get_balance.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({ accountNumber: accountNumberInput.value })
    })
    .then(response => response.json())
    .then(data => {
    if (data.success) {
        // Assuming data.symbol contains the currency symbol, and data.balance contains the balance
        userBalance.textContent = `Balance: ${data.symbol}${data.balance}`;
    } else {
        userBalance.textContent = 'Error fetching balance';
    }
})

    .catch(error => {
        userBalance.textContent = 'Error fetching balance';
    });

    detailsContainer.classList.remove('hidden');
    nextButton.style.display = 'none';
});

transactionForm.addEventListener('submit', function(event) {
    event.preventDefault();
    detailsContainer.style.display = 'none';
    pinContainer.classList.remove('hidden');
});

function appendPin(digit) {
    if (pinInput.value.length < 4) {
        pinInput.value += digit;
    }
    checkPinLength();
}

function deletePin() {
    pinInput.value = pinInput.value.slice(0, -1);
    checkPinLength();
}

function clearPin() {
    pinInput.value = '';
    checkPinLength();
}

function checkPinLength() {
    confirmPinButton.disabled = pinInput.value.length !== 4;
}

confirmPinButton.addEventListener('click', function() {
    const pin = pinInput.value;

    if (pin.length === 4) {
        // Display loader or disable confirm button during processing
        confirmPinButton.disabled = true;

        fetch('validate_pin.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({ pin: pin })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Proceed with OTP generation after PIN validation
                generateOtp(data.userEmail);
            } else {
                alert(data.error || 'Invalid PIN');
                confirmPinButton.disabled = false;
            }
        })
        .catch(error => {
            alert('Error validating PIN: ' + error.message);
            confirmPinButton.disabled = false;
        });
    } else {
        alert('PIN must be 4 digits');
    }
});

function generateOtp(userEmail) {
    fetch('generate_otp.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({ email: userEmail })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // OTP successfully generated, show OTP input form
            otpContainer.classList.remove('hidden');
            alert('OTP has been sent to your email');
        } else {
            alert('Failed to generate OTP');
        }
    })
    .catch(error => {
        alert('Error generating OTP: ' + error.message);
    });
}

document.getElementById('verifyOtpButton').addEventListener('click', function() {
    const otpInput = document.getElementById('otpInput').value;

    if (otpInput.length === 6) {
        // Send the OTP to the server for validation
        fetch('validate_otp.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ otp: otpInput })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // If OTP is valid, alert success and continue the transaction
                alert('OTP verified successfully!');
                // Example: Submit transaction form or call another function to proceed
                document.getElementById('transactionForm').submit();
            } else {
                // If OTP is invalid, show an error message
                alert(data.message || 'Invalid OTP. Please try again.');
            }
        })
        .catch(error => {
            alert('Error verifying OTP: ' + error.message);
        });
    } else {
        alert('Please enter a valid 6-digit OTP.');
    }
});


</script>


<style>
    .hidden { display: none; }
    .tab-pane { padding: 10px; }
</style>

    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.3/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    
<?php require 'server/footer.php' ?>
</body>
</html>
