<?php 
// Enable error reporting for debugging purposes
ini_set('display_errors', 1);
error_reporting(E_ALL);

session_start();
require 'server/config.db.php';
require 'server/login-check.php';
require 'server/header.php';

try {

    // Fetch bank names from database
    $stmt = $pdo->prepare("SELECT DISTINCT bank_name FROM bank_details");
    $stmt->execute();
    $banks = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    echo "Error fetching banks: " . $e->getMessage();
    $banks = [];
}

// Query to get the settings table (default currency and symbol)
$query = "SELECT currency, symbol FROM settings LIMIT 1";
$stmt = $pdo->prepare($query);
$stmt->execute();
$settings = $stmt->fetch(PDO::FETCH_ASSOC);

// Store the values from the settings table
$defaultCurrency = $settings['currency']; // e.g., USD, EUR, etc.
$defaultSymbol = $settings['symbol']; // e.g., $, €, ₦, etc.

$query = "SELECT * FROM users WHERE id = :user_id"; // Get VAT, currency, and symbol for the logged-in user
$stmt = $pdo->prepare($query);
$stmt->execute([':user_id' => $_SESSION['user_id']]); // Assuming user_id is stored in the session
$user = $stmt->fetch(PDO::FETCH_ASSOC);

// Get user currency, symbol, and VAT status from the result
$userCurrency = $user['currency'];
$userSymbol = $user['symbol'];
$userBalance = $user['balance'];
$vatStatus = $user['vat'];

// Determine which currency and symbol to use
$currency = !empty($userCurrency) ? $userCurrency : $defaultCurrency;
$symbol = !empty($userSymbol) ? $userSymbol : $defaultSymbol;
?>
?>

<!DOCTYPE html>
<html lang="en-US" class="js">
<head>
    <meta charset="utf-8">
    <meta name="author" content="Smart">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="This Credit Union is federally insured by the National Credit Union Administration. We do business in accordance with the Fair Housing Law and Equal opportunity Credit Act.">
    <!-- Fav Icon  -->
    <link rel="shortcut icon" href="./logo.png">
    <!-- Page Title  -->
    <title>Universal Transfer</title>
    <!-- StyleSheets  -->
    <link rel="stylesheet" href="../scss/sweetalert.css">
    <link rel="stylesheet" href="../assets/css/dashlite.css?ver=2.4.0">
    <link id="skin-default" rel="stylesheet" href="../assets/css/theme.css?ver=2.4.0">
    <link rel="stylesheet" type="text/css" href="../assets/css/fontawesome.css"> 
    <link href="../css/toastr.css" rel="stylesheet"/>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link rel="stylesheet" href="https://www.jqueryscript.net/demo/jQuery-International-Telephone-Input-With-Flags-Dial-Codes/build/css/intlTelInput.css">
    <script type="text/javascript">
        function googleTranslateElementInit() {
            new google.translate.TranslateElement({pageLanguage: 'en', layout: google.translate.TranslateElement.InlineLayout.SIMPLE}, 'google_translate_element');
        }
    </script>
    <script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>

    <!-- JavaScript to handle form navigation -->
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            let currentStep = 0;
            const formSteps = document.querySelectorAll('.form-step');
            const nextButtons = document.querySelectorAll('.next-button');

            function showStep(stepIndex) {
                formSteps.forEach((step, index) => {
                    step.style.display = (index === stepIndex) ? 'block' : 'none';
                });
            }

            nextButtons.forEach((button, index) => {
                button.addEventListener('click', function() {
                    if (currentStep < formSteps.length - 1) {
                        currentStep++;
                        showStep(currentStep);
                    }
                });
            });

            // Initially show the first step
            showStep(currentStep);
        });
    </script>
</head>
<body class="nk-body npc-crypto bg-white has-sidebar">
    <div class="nk-app-root">
        <!-- main @s -->
        <div class="nk-main">
            <?php require 'server/sidebar.php' ?>
            <!-- sidebar @e -->
            <!-- wrap @s -->
            <div class="nk-wrap">
                <!-- main header @s -->
                <div class="nk-header nk-header-fluid nk-header-fixed is-secondary">
                    <div class="container-fluid">
                        <div class="nk-header-wrap">
                            <div class="nk-menu-trigger d-xl-none ml-n1">
                                <a href="#" class="nk-nav-toggle nk-quick-nav-icon" data-target="sidebarMenu"><em class="icon fas fa-bars"></em></a>
                            </div>
                            <div class="nk-header-brand d-xl-none">
                                <a href="#" class="logo-link">
                                    <img class="logo-light logo-img" src="./logo.png" srcset="./logo.png" alt="logo">
                                    <img class="logo-dark logo-img" src="./logo.png" srcset="./logo.png" alt="logo-dark">
                                </a>
                            </div>
                            <div class="nk-header-news d-none d-xl-block">
                                <div class="nk-news-list">
                                    <a class="nk-news-item" href="#">
                                        <div class="nk-news-icon">
                                            <em class="icon fas fa-bars"></em>
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <?php require 'server/dropdown1.php' ?>
                        </div>
                    </div>
                </div>
                <div class="nk-content">
                    <div class="container mt-5">
    <h2 class="mb-4">Complete Universal Transfer</h2>
    <form id="universalDetailsForm" action="process_universal_transfer.php" method="post">
        <!-- Step 1: Amount -->
        <div class="form-step">
            <div class="form-group">
                <label for="amount">Amount:</label>
                <input type="text" class="form-control" id="amount" name="amount" value="<?= htmlspecialchars($_POST['amount'] ?? '') ?>" readonly required>
            </div>
            <button type="button" class="btn btn-primary next-button">Proceed</button>
        </div>

        <!-- Step 2: Account Number -->
        <div class="form-step" style="display: none;">
            <div class="form-group">
                <label for="accountNumber">Account Number:</label>
                <input type="text" class="form-control" id="accountNumber" name="accountNumber" maxlength="20" required>
            </div>
            <button type="button" class="btn btn-primary next-button">Proceed</button>
        </div>

        <!-- Step 3: Bank Name -->
        <div class="form-step" style="display: none;">
            <div class="form-group">
                <label for="bankName">Bank Name:</label>
                <select class="form-control" id="bankName" name="bankName" required>
                    <option value="">Select Bank</option>
                    <?php 
                    if (!empty($banks)) {
                        foreach ($banks as $bank) {
                            echo '<option value="' . htmlspecialchars($bank['bank_name']) . '">' . htmlspecialchars($bank['bank_name']) . '</option>';
                        }
                    } else {
                        echo '<option value="">No banks available</option>';
                    }
                    ?>
                </select>
            </div>
            <button type="button" class="btn btn-primary next-button">Proceed</button>
        </div>

        <!-- Step 4: SWIFT Code -->
        <div class="form-step" style="display: none;">
            <div class="form-group">
                <label for="swiftCode">SWIFT Code:</label>
                <input type="text" class="form-control" id="swiftCode" name="swiftCode" required>
            </div>
            <button type="button" class="btn btn-primary next-button">Proceed</button>
        </div>

        <!-- Step 5: Routing Number -->
        <div class="form-step" style="display: none;">
            <div class="form-group">
                <label for="routingNumber">Routing Number:</label>
                <input type="text" class="form-control" id="routingNumber" name="routingNumber" maxlength="9" required>
            </div>
            <button type="button" class="btn btn-primary next-button">Proceed</button>
        </div>

        <!-- PIN Validation Section -->
<div id="pinContainer" class="form-step" style="display: none;">
    <h3>Enter PIN</h3>
    <input type="password" id="pinInput" class="form-control mb-3" maxlength="4" required>
    <button type="button" class="btn btn-primary" id="confirmPinButton" disabled>Confirm PIN</button>
</div>


        <!-- OTP Verification Section -->
        <div id="otpContainer" class="form-step" style="display: none;">
            <h3>OTP Verification</h3>
            <input type="text" id="otpInput" class="form-control" maxlength="6" required placeholder="Enter OTP">
            <button class="btn btn-primary" id="verifyOtpButton">Verify OTP</button>
        </div>

        <!-- Submit Transfer Button -->
        <button type="submit" class="btn btn-success" id="finalSubmitButton" style="display: none;">Submit Transfer</button>
    </form>
</div>

<script>
// JavaScript to handle form steps, PIN, OTP and validation

const pinContainer = document.getElementById('pinContainer');
const otpContainer = document.getElementById('otpContainer');
const confirmPinButton = document.getElementById('confirmPinButton');
const otpInput = document.getElementById('otpInput');
const verifyOtpButton = document.getElementById('verifyOtpButton');
const finalSubmitButton = document.getElementById('finalSubmitButton');

let userEmail = ''; // Store user email after PIN validation

// JavaScript for PIN functionality

document.addEventListener('DOMContentLoaded', function () {
    const confirmPinButton = document.getElementById('confirmPinButton');
    const pinInput = document.getElementById('pinInput');

    function checkPinLength() {
        confirmPinButton.disabled = pinInput.value.length !== 4;
    }

    pinInput.addEventListener('input', checkPinLength);

    confirmPinButton.addEventListener('click', function () {
    const pin = pinInput.value;
    if (pin.length === 4) {
        confirmPinButton.disabled = true;

        // Make request to validate PIN
        fetch('validate_pin.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({ pin: pin })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                const userEmail = data.userEmail; // Get the user email for OTP generation
                generateOtp(userEmail);  // Generate OTP and reveal the OTP step
                showStep(++currentStep); // Transition to OTP verification step
            } else {
                alert('Invalid PIN');
                confirmPinButton.disabled = false;
            }
        })
        .catch(error => {
            alert('Error validating PIN: ' + error.message);
            confirmPinButton.disabled = false;
        });
    } else {
        alert('PIN must be 4 digits');
    }
});

});

// Function to generate OTP after successful PIN validation
function generateOtp(userEmail) {
    fetch('generate_otp.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({ email: userEmail })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // OTP successfully generated, show OTP input form
            const otpContainer = document.getElementById('otpContainer');
            otpContainer.style.display = 'block'; // Ensure OTP container is visible
            alert('OTP has been sent to your email');
        } else {
            alert('Failed to generate OTP');
        }
    })
    .catch(error => {
        alert('Error generating OTP: ' + error.message);
    });
}


// Form step navigation
let currentStep = 0;
const steps = document.querySelectorAll('.form-step');

function showStep(stepIndex) {
    steps.forEach((step, index) => {
        step.style.display = index === stepIndex ? 'block' : 'none';
    });
}

document.querySelectorAll('.next-button').forEach((button, index) => {
    button.addEventListener('click', function() {
        currentStep++;
        if (currentStep === steps.length - 1) {
            pinContainer.style.display = 'block';
        } else {
            showStep(currentStep);
        }
    });
});

showStep(currentStep); // Initialize form display
</script>

                </div>
            </div>
        </div>
    </div>

    <!-- Include JS files for Bootstrap, jQuery, etc. -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.3/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

    <?php require 'server/footer.php' ?>
</body>
</html>
