<?php
// Enable error reporting for debugging purposes
error_reporting(E_ALL);
ini_set('display_errors', 1);
require 'server/config.db.php';

$data = json_decode(file_get_contents('php://input'), true);
$accountNumber = $data['accountNumber'] ?? '';

if ($accountNumber) {
    $stmt = $pdo->prepare('SELECT full_name FROM users WHERE account_number = :accountNumber');
    $stmt->execute(['accountNumber' => $accountNumber]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user) {
        echo json_encode(['success' => true, 'full_name' => $user['full_name']]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Account number not found']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid input']);
}
?>