<?php
session_start();
require 'server/config.db.php';

$data = json_decode(file_get_contents('php://input'), true);
$pin = $data['pin'] ?? '';

if (empty($pin)) {
    echo json_encode(['success' => false, 'error' => 'PIN is required.']);
    exit;
}

$user_id = $_SESSION['user_id'];

$stmt = $pdo->prepare("SELECT pin FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$user = $stmt->fetch();

if (!$user) {
    echo json_encode(['success' => false, 'error' => 'User not found.']);
    exit;
}

// Debugging: Log fetched PIN and provided PIN
error_log('Fetched PIN: ' . $user['pin']);
error_log('Provided PIN: ' . $pin);

if ($pin === $user['pin']) {
    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'error' => 'Incorrect PIN.']);
}
?>
