<?php
// Enable error reporting for debugging purposes
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
require 'server/config.db.php';
require 'server/login-check.php';
require 'server/header.php';

// Check if the user has a virtual card
$user_id = $_SESSION['user_id']; // Assuming you store user_id in session
$query = "SELECT card FROM users WHERE id = ?";
$stmt = $pdo->prepare($query);
$stmt->execute([$user_id]);
$card = $stmt->fetchColumn();


// Query to get the settings table (default currency and symbol)
$query = "SELECT currency, symbol FROM settings LIMIT 1";
$stmt = $pdo->prepare($query);
$stmt->execute();
$settings = $stmt->fetch(PDO::FETCH_ASSOC);

// Store the values from the settings table
$defaultCurrency = $settings['currency']; // e.g., USD, EUR, etc.
$defaultSymbol = $settings['symbol']; // e.g., $, €, ₦, etc.

$query = "SELECT * FROM users WHERE id = :user_id"; // Get VAT, currency, and symbol for the logged-in user
$stmt = $pdo->prepare($query);
$stmt->execute([':user_id' => $_SESSION['user_id']]); // Assuming user_id is stored in the session
$user = $stmt->fetch(PDO::FETCH_ASSOC);

// Get user currency, symbol, and VAT status from the result
$userCurrency = $user['currency'];
$userSymbol = $user['symbol'];
$userBalance = $user['balance'];
$vatStatus = $user['vat'];

// Determine which currency and symbol to use
$currency = !empty($userCurrency) ? $userCurrency : $defaultCurrency;
$symbol = !empty($userSymbol) ? $userSymbol : $defaultSymbol;
?>
?>
    <!DOCTYPE html>
<html lang="en-US" class="js">
    <head>
    <meta charset="utf-8">
    <meta name="author" content="Smart">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="This Credit Union is federally insured by the National Credit Union Administration. We do business in accordance with the Fair Housing Law and Equal opportunity Credit Act.">
    <!-- Fav Icon  -->
    <link rel="shortcut icon" href="./logo.png">
    <!-- Page Title  -->
    <title>SwiftHeart Virtual Card</title>
    <!-- StyleSheets  -->
    <link rel="stylesheet" href="../scss/sweetalert.css">
    <link rel="stylesheet" href="../assets/css/dashlite.css?ver=2.4.0">
    <link id="skin-default" rel="stylesheet" href="../assets/css/theme.css?ver=2.4.0">
     <link rel="stylesheet" type="text/css" href="../assets/css/fontawesome.css"> 
     <link href="../css/toastr.css" rel="stylesheet"/>
     <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
   </head>
    <link rel="stylesheet" href="https://www.jqueryscript.net/demo/jQuery-International-Telephone-Input-With-Flags-Dial-Codes/build/css/intlTelInput.css">
   <script type="text/javascript">
function googleTranslateElementInit() {
  new google.translate.TranslateElement({pageLanguage: 'en', layout: google.translate.TranslateElement.InlineLayout.SIMPLE}, 'google_translate_element');
}
</script>
<script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
    <style>
.goog-te-gadget-simple {
border:none;
}
.goog-te-gadget-simple a {
color:#000;
}
</style>
<style type="text/css">
    .btn-primary{
        background-color: #033d75;
    }
    .btn-secondary{
        background-color: #d13636;
    }
    .btn-secondary:hover{opacity: 0.6;}
    .btn-primary:hover{opacity: 0.6;}
    
    .preloader {
            position: fixed;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background: rgba(255, 255, 255, 0.8);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 9999;
        }
        .preloader img {
            width: 100px; /* Adjust the size of the spinner */
        }
        body {
            overflow: hidden; /* Prevent scrolling while loading */
        }
        body.loaded {
            overflow: auto;
        }
</style>
<body class="nk-body npc-crypto bg-white has-sidebar ">
  
    <div class="nk-app-root">
        <!-- main @s -->
        <div class="nk-main ">
            <?php require 'server/sidebar.php' ?>
            <!-- sidebar @e -->
            <!-- wrap @s -->
            <div class="nk-wrap ">
                <!-- main header @s -->
                <div class="nk-header nk-header-fluid nk-header-fixed is-secondary">
                    <div class="container-fluid">
                        <div class="nk-header-wrap">
                            <div class="nk-menu-trigger d-xl-none ml-n1">
                                <a href="#" class="nk-nav-toggle nk-quick-nav-icon" data-target="sidebarMenu"><em class="icon fas fa-bars"></em></a>
                            </div>
                            <div class="nk-header-brand d-xl-none">
                                <a href="#" class="logo-link">
                                    <img class="logo-light logo-img" src="./logo.png" srcset="./logo.png" alt="logo">
                                    <img class="logo-dark logo-img" src="./logo.png" srcset="../logo.png" alt="logo-dark">
  
                                </a>
                            </div>
                            <div class="nk-header-news d-none d-xl-block">
                                <div class="nk-news-list">
                                    <a class="nk-news-item" href="#">
                                        <div class="nk-news-icon">
                                            <em class="icon fas fa-bars"></em>
                                        </div>
                                    </a>
                                </div>
                            </div>
                            <?php require 'server/dropdown1.php' ?>
                        </div>
                    </div>
                </div>
                <!-- main header @e -->                <!-- content @s -->
                <!-- main header @e -->                
                <div class="nk-content nk-content-fluid">
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="kyc-app wide-sm m-auto">
                <div class="nk-block-head nk-block-head-lg wide-xs mx-auto">
                    <div class="nk-block-head-content text-center">
                        <h2 class="nk-block-title fw-normal">MasterCard</h2>
                        <div class="nk-block-des">
                            <p>Specially designed for your online transactions.</p>
                        </div>
                    </div>
                </div><!-- nk-block-head -->
                <div class="nk-block">
                    <div class="card card-bordered">
                        <div class="card-inner card-inner-lg">
                            <div class="nk-kyc-app p-sm-2 text-center">
                                <div class="nk-kyc-app-icon">
                                    <em class="fa-solid fa-bullseye text-primary" style="font-size: 49px;"></em>
                                </div>
                                <div class="nk-kyc-app-text mx-auto">
                                    <p class="lead">The Swift Tess MasterCard is a digital payment card designed to facilitate frequent online shoppers with a secure and flexible alternative to physical payment cards. The Mastercard is instantly issued upon request.</p>
                                </div>
                                <div class="nk-kyc-app-action">
                                    <button id="requestCardBtn" class="btn btn-lg btn-primary"><em class="fa-solid fa-credit-card"></em> Request for a New MasterCard</button>
                                </div>
                                <p class="nk-kyc-app-action" style="margin-top: 10px;">
                                    <a href="new-virtual-card" class="btn btn-lg btn-default border-dark"><em class="fa-duotone fa-solid fa-credit-card"></em> Manage Existing MasterCards</a>
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="text-center pt-4">
                        <p>If you have any questions, please contact our support team <a href="mailto:info@swifttess.com">info@swifttess.com</a></p>
                    </div>
                </div><!-- nk-block -->
            </div><!-- kyc-app -->
        </div>
    </div>
</div>

<?php
if ($card == 0) {
    echo "<script>
    document.addEventListener('DOMContentLoaded', function() {
        var modal = document.getElementById('requestCardModal');
        modal.style.display = 'block';
    });
    </script>";
}
?>

<!-- Popup Form Modal -->
<div id="requestCardModal" class="modal">
    <div class="modal-content">
        <span class="close">&times;</span>
        <form id="requestCardForm" action="submit_card_request.php" method="post">
            <?php
            // Fetch user details from the database
            $query = "SELECT full_name, account_number, address, phone FROM users WHERE id = ?";
            $stmt = $pdo->prepare($query);
            $stmt->execute([$user_id]);
            $user = $stmt->fetch(PDO::FETCH_ASSOC);
            ?>
            <h2>Request New Virtual Card</h2>
            <label for="name">Name:</label>
            <input type="text" id="name" name="name" value="<?php echo htmlspecialchars($user['full_name']); ?>" readonly><br>
            <label for="account_number">Account Number:</label>
            <input type="text" id="account_number" name="account_number" value="<?php echo htmlspecialchars($user['account_number']); ?>" readonly><br>
            <label for="address">Address:</label>
            <input type="text" id="address" name="address" value="<?php echo htmlspecialchars($user['address']); ?>" readonly><br>
            
            <label for="phone">Phone:</label>
            <input type="text" id="phone" name="phone" value="<?php echo htmlspecialchars($user['phone']); ?>" readonly><br>
            <button type="submit">Continue</button>
        </form>
    </div>
</div>

<style>
/* The Modal (background) */
.modal {
    display: none; 
    position: fixed; 
    z-index: 1; 
    padding-top: 60px; 
    left: 0;
    top: 0;
    width: 100%; 
    height: 100%; 
    overflow: auto; 
    background-color: rgb(0,0,0); 
    background-color: rgba(0,0,0,0.4); 
}

/* Modal Content */
.modal-content {
    background-color: #fefefe;
    margin: 5% auto; 
    padding: 20px;
    border: 1px solid #888;
    width: 80%; 
    max-width: 500px;
    text-align: left;
    box-shadow: 0 4px 8px rgba(0,0,0,0.2);
    animation-name: animatetop;
    animation-duration: 0.4s;
}

/* Add Animation */
@keyframes animatetop {
    from {top: -300px; opacity: 0}
    to {top: 0; opacity: 1}
}

/* The Close Button */
.close {
    color: #aaa;
    float: right;
    font-size: 28px;
    font-weight: bold;
}

.close:hover,
.close:focus {
    color: black;
    text-decoration: none;
    cursor: pointer;
}

.modal-content form {
    display: flex;
    flex-direction: column;
}

.modal-content form label {
    margin: 10px 0 5px;
}

.modal-content form input {
    padding: 10px;
    margin-bottom: 15px;
    border: 1px solid #ccc;
    border-radius: 4px;
}

.modal-content form button {
    padding: 10px;
    background-color: #4CAF50;
    color: white;
    border: none;
    border-radius: 4px;
    cursor: pointer;
}

.modal-content form button:hover {
    background-color: #45a049;
}
</style>

<script>
// Get the modal
var modal = document.getElementById("requestCardModal");

// Get the button that opens the modal
var btn = document.getElementById("requestCardBtn");

// Get the <span> element that closes the modal
var span = document.getElementsByClassName("close")[0];

// When the user clicks the button, open the modal
btn.onclick = function() {
    modal.style.display = "block";
}

// When the user clicks on <span> (x), close the modal
span.onclick = function() {
    modal.style.display = "none";
}

// When the user clicks anywhere outside of the modal, close it
window.onclick = function(event) {
    if (event.target == modal) {
        modal.style.display = "none";
    }
}
</script>
            <?php require 'server/footer.php' ?>
   
</body>

</html>