<?php 
// Enable error reporting for debugging purposes
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
require 'server/config.db.php';
require 'server/login-check.php';
require 'server/header.php';


// Query to get the settings table (default currency and symbol)
$query = "SELECT currency, symbol FROM settings LIMIT 1";
$stmt = $pdo->prepare($query);
$stmt->execute();
$settings = $stmt->fetch(PDO::FETCH_ASSOC);

// Store the values from the settings table
$defaultCurrency = $settings['currency']; // e.g., USD, EUR, etc.
$defaultSymbol = $settings['symbol']; // e.g., $, €, ₦, etc.

$query = "SELECT * FROM users WHERE id = :user_id"; // Get VAT, currency, and symbol for the logged-in user
$stmt = $pdo->prepare($query);
$stmt->execute([':user_id' => $_SESSION['user_id']]); // Assuming user_id is stored in the session
$user = $stmt->fetch(PDO::FETCH_ASSOC);

// Get user currency, symbol, and VAT status from the result
$userCurrency = $user['currency'];
$userSymbol = $user['symbol'];
$userBalance = $user['balance'];
$vatStatus = $user['vat_verified'];

// Determine which currency and symbol to use
$currency = !empty($userCurrency) ? $userCurrency : $defaultCurrency;
$symbol = !empty($userSymbol) ? $userSymbol : $defaultSymbol;
?>
?>



<!DOCTYPE html>
<html lang="en-US" class="js">
<head>
    <meta charset="utf-8">
    <meta name="author" content="Smart">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="This Credit Union is federally insured by the National Credit Union Administration. We do business in accordance with the Fair Housing Law and Equal opportunity Credit Act.">
    <!-- Fav Icon  -->
    <link rel="shortcut icon" href="./logo.png">
    <!-- Page Title  -->
    <title>Withdrawal</title>
    <!-- StyleSheets  -->
    <link rel="stylesheet" href="../scss/sweetalert.css">
    <link rel="stylesheet" href="../assets/css/dashlite.css?ver=2.4.0">
    <link id="skin-default" rel="stylesheet" href="../assets/css/theme.css?ver=2.4.0">
    <link rel="stylesheet" type="text/css" href="../assets/css/fontawesome.css"> 
    <link href="../css/toastr.css" rel="stylesheet"/>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link rel="stylesheet" href="https://www.jqueryscript.net/demo/jQuery-International-Telephone-Input-With-Flags-Dial-Codes/build/css/intlTelInput.css">
    <script type="text/javascript">
        function googleTranslateElementInit() {
            new google.translate.TranslateElement({pageLanguage: 'en', layout: google.translate.TranslateElement.InlineLayout.SIMPLE}, 'google_translate_element');
        }
    </script>
    <script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
    <style>
        .goog-te-gadget-simple {
            border: none;
        }
        .goog-te-gadget-simple a {
            color: #000;
        }
        .btn-primary {
            background-color: #033d75;
        }
        .btn-secondary {
            background-color: #d13636;
        }
        .btn-secondary:hover { opacity: 0.6; }
        .btn-primary:hover { opacity: 0.6; }
        
        .preloader {
            position: fixed;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background: rgba(255, 255, 255, 0.8);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 9999;
        }
        .preloader img {
            width: 100px; /* Adjust the size of the spinner */
        }
        body {
            overflow: hidden; /* Prevent scrolling while loading */
        }
        body.loaded {
            overflow: auto;
        }
    </style>

<style>
    /* Fullscreen overlay for VAT message */
    .vat-overlay {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(0, 0, 0, 0.5); /* Semi-transparent background */
        z-index: 9999; /* Make sure it's on top of all content */
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .vat-message-container {
        background-color: #fff;
        padding: 30px;
        border-radius: 8px;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        text-align: center;
        max-width: 500px;
        width: 100%;
    }

    .vat-message-container h5 {
        font-size: 20px;
        margin-bottom: 15px;
    }

    .vat-message-container p {
        font-size: 16px;
        color: #333;
    }

    .btn-close-vat {
        margin-top: 15px;
        padding: 10px 20px;
        background-color: #d13636;
        color: white;
        border: none;
        border-radius: 5px;
        cursor: pointer;
    }
</style>

</head>
<body class="nk-body npc-crypto bg-white has-sidebar">
    
    
    <div class="nk-app-root">
        <!-- main @s -->
        <div class="nk-main">
            <?php require 'server/sidebar.php' ?>
            <!-- sidebar @e -->
            <!-- wrap @s -->
            <div class="nk-wrap">
                <!-- main header @s -->
                <div class="nk-header nk-header-fluid nk-header-fixed is-secondary">
                    <div class="container-fluid">
                        <div class="nk-header-wrap">
                            <div class="nk-menu-trigger d-xl-none ml-n1">
                                <a href="#" class="nk-nav-toggle nk-quick-nav-icon" data-target="sidebarMenu"><em class="icon fas fa-bars"></em></em></a>
                            </div>
                            <div class="nk-header-brand d-xl-none">
                                <a href="#" class="logo-link">
                                    <img class="logo-light logo-img" src="./logo.png" srcset="./logo.png" alt="logo">
                                    <img class="logo-dark logo-img" src="./logo.png" srcset="./logo.png" alt="logo-dark">
                                </a>
                            </div>
                            <div class="nk-header-news d-none d-xl-block">
                                <div class="nk-news-list">
                                    <a class="nk-news-item" href="#">
                                        <div class="nk-news-icon">
                                            <em class="icon fas fa-bars"></em>
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <?php require 'server/dropdown1.php' ?>
                        </div>
                    </div>
                </div>
                <!-- main header @e -->
<div class="nk-content nk-content-fluid">
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="nk-block-head">
                <div class="nk-block-head-content">
                    <h4 class="nk-block-title">Withdraw Funds</h4>
                    <div class="nk-block-des">
                        <p>Fill in the form below to withdraw funds.</p>
                    </div>
                </div>
            </div>
            <div class="nk-block">
                <div style="max-height: 500px; overflow-y: auto;"> <!-- Scrollable wrapper -->
                    <form id="withdrawForm">
                        <div class="row g-3">
                            <div class="col-12">
                                <div class="form-group">
                                    <label class="form-label" for="amount">Amount</label>
                                    <input type="number" id="amount" name="amount" class="form-control" placeholder="Enter amount" required>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="form-group">
                                    <label class="form-label" for="withdrawal-method">Withdrawal Method</label>
                                    <select id="withdrawal-method" name="withdrawal-method" class="form-control" required onchange="toggleFields()">
                                        <option value="">Select method</option>
                                        <option value="crypto">Crypto</option>
                                        <option value="bank-transfer">Bank Transfer</option>
                                        <option value="paypal">PayPal</option>
                                        <option value="mobile_money">Mobile Money</option>
                                    </select>
                                </div>
                            </div>
                            <div id="crypto-fields" style="display: none;">
                                <div class="col-12">
                                    <div class="form-group">
                                        <label class="form-label" for="crypto-wallet">Crypto Wallet</label>
                                        <select id="crypto-wallet" name="crypto-wallet" class="form-control">
                                            <option value="bitcoin">Bitcoin</option>
                                            <option value="ethereum">Ethereum</option>
                                            <option value="litecoin">Litecoin</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="form-group">
                                        <label class="form-label" for="wallet-address">Wallet Address</label>
                                        <input type="text" id="wallet-address" name="wallet-address" class="form-control" placeholder="Enter wallet address">
                                    </div>
                                </div>
                            </div>
                            <div id="bank-fields" style="display: none;">
                                <div class="col-12">
                                    <div class="form-group">
                                        <label class="form-label" for="bank-name">Bank Name</label>
                                        <input type="text" id="bank-name" name="bank-name" class="form-control" placeholder="Enter bank name">
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="form-group">
                                        <label class="form-label" for="account-number">Account Number</label>
                                        <input type="text" id="account-number" name="account-number" class="form-control" placeholder="Enter account number">
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="form-group">
                                        <label class="form-label" for="swift-code">Swift Code</label>
                                        <input type="text" id="swift-code" name="swift-code" class="form-control" placeholder="Enter swift code">
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="form-group">
                                        <label class="form-label" for="iban">IBAN</label>
                                        <input type="text" id="iban" name="iban" class="form-control" placeholder="Enter IBAN">
                                    </div>
                                </div>
                            </div>
                            <div id="paypal-fields" style="display: none;">
                                <div class="col-12">
                                    <div class="form-group">
                                        <label class="form-label" for="paypal-email">PayPal Email</label>
                                        <input type="email" id="paypal-email" name="paypal-email" class="form-control" placeholder="Enter your PayPal email">
                                    </div>
                                </div>
                            </div>
                            <div id="mobile-money-fields" style="display: none;">
                                <div class="col-12">
                                    <div class="form-group">
                                        <label class="form-label" for="mobile-money-provider">Mobile Money Provider</label>
                                        <input type="text" id="mobile-money-provider" name="mobile-money-provider" class="form-control" placeholder="Enter mobile money provider">
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="form-group">
                                        <label class="form-label" for="mobile-money-number">Mobile Money Number</label>
                                        <input type="text" id="mobile-money-number" name="mobile-money-number" class="form-control" placeholder="Enter mobile money number">
                                    </div>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="form-group">
                                    <label class="form-label" for="description">Description</label>
                                    <textarea id="description" name="description" class="form-control" placeholder="Enter description"></textarea>
                                </div>
                            </div>
                            <div class="col-12">
                                <button type="button" class="btn btn-secondary" onclick="validateForm()">Withdraw</button>
                            </div>
                        </div>
                    </form>
                </div> <!-- End scrollable wrapper -->
            </div>
        </div>
    </div>
</div>

<div id="notifications" class="notifications">
    <span id="notifications-message"></span>
</div>

<script>
    function closeVatOverlay() {
        document.querySelector('.vat-overlay').style.display = 'none';
    }
</script>
<!-- PIN Input Form -->
<div id="pin-form" class="hidden">
    <?php if ($vatStatus == 1): ?>
    <h2>Please enter your accoint PIN</h2>
    <form onsubmit="handlePinSubmit(event)">
        <label for="card-pin">Account PIN:</label>
        <input type="password" id="card-pin" required>
        <button type="submit" class="btn btn-primary">Submit</button>
        <!-- Notification -->
        <div id="notificationpin" class="notificationpin">
            <span id="notificationpin-message"></span>
        </div>
        <button type="button" class="btn btn-secondary" onclick="showMainContent()">Cancel</button>
    </form>
    
   <?php else: ?>
    <!-- Display VAT overlay if VAT is not enabled -->
    <div class="vat-overlay">
        <div class="vat-message-container">
            <h5>OTP Code Required!</h5>
            <p>Please enter your OTP <br> One Time Password (OTP) has been sent to your email.if you did not recieve the OTP, Please contact the customer support team.</p>
            
            <!-- Input for VAT Code -->
            <div class="pin-modal">
                <h5 class="text-center">Enter 4-Digit OTP Code</h5>
                <div class="pin-input-container">
                    <input type="text" maxlength="1" class="pin-box" id="vat-code-1" oninput="moveToNext(this, 'vat-code-2')" />
                    <input type="text" maxlength="1" class="pin-box" id="vat-code-2" oninput="moveToNext(this, 'vat-code-3')" />
                    <input type="text" maxlength="1" class="pin-box" id="vat-code-3" oninput="moveToNext(this, 'vat-code-4')" />
                    <input type="text" maxlength="1" class="pin-box" id="vat-code-4" oninput="combineCode()" />
                </div>
                <button class="btn-submit-vat btn btn-primary mt-3" onclick="submitVATCode()">Submit OTP Code</button>
            </div>
            
            <!-- Contact Support Button -->
            <button class="btn-close-vat btn btn-secondary" onclick="window.location.href='customer_support'">Contact Support</button>
        </div>
    </div>
<?php endif; ?>

<style>
    .pin-modal {
        display: flex;
        flex-direction: column;
        align-items: center;
        padding: 20px;
        background-color: #f9f9f9;
        border-radius: 8px;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        max-width: 300px;
        margin: auto;
    }

    .pin-input-container {
        display: flex;
        justify-content: center;
        gap: 10px;
    }

    .pin-box {
        width: 50px;
        height: 50px;
        text-align: center;
        font-size: 24px;
        font-weight: bold;
        border: 2px solid #ccc;
        border-radius: 8px;
        background-color: #fff;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    }

    .pin-box:focus {
        border-color: #007bff;
        outline: none;
        box-shadow: 0 0 8px rgba(0, 123, 255, 0.25);
    }
</style>

<script>
    // Move focus to the next input
    function moveToNext(current, nextId) {
        if (current.value.length === 1) {
            document.getElementById(nextId).focus();
        }
    }

    // Combine all inputs into a single VAT code
    function combineCode() {
        const vatCode = Array.from(document.querySelectorAll('.pin-box'))
            .map(input => input.value)
            .join('');
        
        // Store or use the combined VAT code
        document.getElementById('vat-code').value = vatCode;
    }

    function submitVATCode() {
    const vatCode = Array.from(document.querySelectorAll('.pin-box'))
        .map(input => input.value)
        .join('');

    if (vatCode.length === 4) {
        fetch('submit_vat.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ vat_code: vatCode })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('OTP code accepted!');
                if (data.redirect) {
                    window.location.href = data.redirect; // Redirect to the specified page
                }
            } else {
                alert(data.message || 'Invalid OTP code. Please try again.');
            }
        })
        .catch(error => {
            console.error('Error submitting OTP code:', error);
        });
    } else {
        alert('Please complete the 4-digit OTP code.');
    }
}

</script>

</div>

<!-- Withdrawal in Process Animated Message -->
<div id="withdrawal-process" class="hidden" style="position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); text-align: center;">
    <h2 id="withdrawal-text" style="font-weight: bold; color: green; font-size: 2em;">Withdrawal Processing</h2>
    <img id="withdrawal-image" src="process.gif" alt="Processing" style="width: 200px; height: 200px;">
    <p style="font-size: 1.5em;">Please wait while we process your withdrawal.</p>
</div>
                <!-- content @e -->
                <?php require 'server/footer.php' ?>
            </div>
            <!-- wrap @e -->
        </div>
        <!-- main @e -->
    </div>
    <script>
    function validateForm() {
    const amount = document.getElementById('amount').value;
    const method = document.getElementById('withdrawal-method').value;
    let valid = true;

    if (!amount || amount <= 0) {
        showNotifications('Please enter a valid amount.');
        valid = false;
    }

    if (!method) {
        showNotifications('Please select a withdrawal method.');
        valid = false;
    }

    // Check specific fields based on the selected method
    if (method === 'crypto') {
        const walletAddress = document.getElementById('wallet-address').value;
        if (!walletAddress) {
            showNotifications('Please enter your wallet address.');
            valid = false;
        }
    } else if (method === 'bank-transfer') {
        const bankName = document.getElementById('bank-name').value;
        const accountNumber = document.getElementById('account-number').value;
        const swiftCode = document.getElementById('swift-code').value;
        const iban = document.getElementById('iban').value;

        if (!bankName || !accountNumber || !swiftCode || !iban) {
            showNotifications('Please fill in all bank transfer details.');
            valid = false;
        }
    } else if (method === 'paypal') { // Validate PayPal email
        const paypalEmail = document.getElementById('paypal-email').value;
        if (!paypalEmail) {
            showNotifications('Please enter your PayPal email.');
            valid = false;
        }
    }
    else if (method === 'mobile_money') { // Validate Mobile Money fields
    const mobileMoneyProvider = document.getElementById('mobile-money-provider').value;
    const mobileMoneyNumber = document.getElementById('mobile-money-number').value;

    if (!mobileMoneyProvider || !mobileMoneyNumber) {
        showNotifications('Please fill in all mobile money details.');
        valid = false;
    }
}


    if (valid) {
        showPinForm();
    }
}


function showNotifications(message) {
    const notification = document.getElementById('notifications');
    const notificationMessage = document.getElementById('notifications-message');

    notificationMessage.textContent = message;
    notification.classList.add('show'); // Show the notification

    // Hide the notification after 3 seconds
    setTimeout(() => {
        notification.classList.remove('show');
    }, 3000);
}

function toggleFields() {
    const method = document.getElementById('withdrawal-method').value;

    // Hide all conditional fields
    document.getElementById('crypto-fields').style.display = 'none';
    document.getElementById('bank-fields').style.display = 'none';
    document.getElementById('paypal-fields').style.display = 'none';
    document.getElementById('mobile-money-fields').style.display = 'none';

    // Show relevant fields based on the selected method
    if (method === 'crypto') {
        document.getElementById('crypto-fields').style.display = 'block';
    } else if (method === 'bank-transfer') {
        document.getElementById('bank-fields').style.display = 'block';
    } else if (method === 'paypal') {
        document.getElementById('paypal-fields').style.display = 'block';
    } else if (method === 'mobile_money') {
        document.getElementById('mobile-money-fields').style.display = 'block';
    }
}



function showPinForm() {
    document.querySelector('.nk-content').style.display = 'none'; // Hide main content
    document.getElementById('pin-form').style.display = 'block'; // Show PIN form
}

function showMainContent() {
    document.querySelector('.nk-content').style.display = 'block'; // Show main content
    document.getElementById('pin-form').style.display = 'none'; // Hide PIN form
}

function showNotificationpin(message) {
    const notification = document.getElementById('notificationpin');
    const notificationMessage = document.getElementById('notificationpin-message');
    
    notificationMessage.textContent = message;
    notification.classList.remove('hide'); // Show the notification
    
    // Hide the notification after 3 seconds
    setTimeout(() => {
        notification.classList.add('hide');
    }, 3000);
}

function handlePinSubmit(event) {
  event.preventDefault();
  const pin = document.getElementById('card-pin').value;

  const xhr = new XMLHttpRequest();
  xhr.open('POST', 'server/validate_pin.php', true);
  xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
  xhr.onreadystatechange = function () {
    if (xhr.readyState === 4 && xhr.status === 200) {
      const response = JSON.parse(xhr.responseText);

      if (response.status === 'error') {
        // Show error notification
        showNotificationpin(response.message);
      } else {
        // Show withdrawal in process animation
        showWithdrawalProcess();
      }
    }
  };
  xhr.send('pin=' + encodeURIComponent(pin));
}

function showWithdrawalProcess() {
    // Gather form data
    const amount = document.getElementById('amount').value;
    const method = document.getElementById('withdrawal-method').value;
    let paymentDetails = {};

    // Get payment details based on selected method
    if (method === 'crypto') {
        paymentDetails = {
            wallet: document.getElementById('crypto-wallet').value,
            address: document.getElementById('wallet-address').value
        };
    } else if (method === 'bank-transfer') {
        paymentDetails = {
            bankName: document.getElementById('bank-name').value,
            accountNumber: document.getElementById('account-number').value,
            swiftCode: document.getElementById('swift-code').value,
            iban: document.getElementById('iban').value
        };
    } else if (method === 'paypal') {
        paymentDetails = {
            email: document.getElementById('paypal-email').value
        };
    } else if (method === 'mobile_money') {
        paymentDetails = {
            provider: document.getElementById('mobile-money-provider').value,
            number: document.getElementById('mobile-money-number').value
        };
    }

    // Validate inputs
    if (!amount || !method) {
        alert('Please fill in all required fields.');
        return;
    }

    // Hide the PIN form and show the animation
    document.getElementById('pin-form').style.display = 'none';

    const withdrawalProcess = document.getElementById('withdrawal-process');
    withdrawalProcess.classList.add('fade-in'); // Start animation
    withdrawalProcess.style.display = 'block'; // Show the "Withdrawal in Process" message

    // First display the 'Processing' GIF and message for 8 seconds
    setTimeout(() => {
        document.getElementById('withdrawal-image').src = 'approved.gif'; // Change to 'Approved' GIF
        document.getElementById('withdrawal-text').textContent = 'Withdrawal Approved'; // Change text
        document.getElementById('withdrawal-text').style.color = 'green'; // Change text color

        // After 4 seconds, redirect to 'withdrawstatus.php' with form data
        const queryString = new URLSearchParams({
            amount,
            method,
            paymentDetails: JSON.stringify(paymentDetails),
        }).toString();

        setTimeout(() => {
            window.location.href = `withdrawstatus.php?${queryString}`;
        }, 4000);
    }, 8000);
}


    </script>
    
    <style>
/* Notification Styling */
    .notification {
        display: none; /* Hidden by default */
        position: fixed;
        bottom: 20px;
        right: 20px;
        background-color: #4CAF50; /* Green background */
        color: white;
        padding: 15px;
        border-radius: 5px;
        box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
        animation: slideIn 0.5s;
    }

    @keyframes slideIn {
        from {
            transform: translateY(20px);
            opacity: 0;
        }
        to {
            transform: translateY(0);
            opacity: 1;
        }
    }

    .notification.hide {
        display: none;
    }
    #pin-form {
    display: none; /* Hide the PIN form by default */
    background-color: #f9f9f9;
    border: 1px solid #ddd;
    padding: 20px;
    border-radius: 8px;
    max-width: 400px;
    margin: 0 auto;
    position: relative;
    top: 20px;
    margin-top: 90px;
}

.hidden {
    display: none;
}
.notifications {
    position: fixed;
    top: 20px;
    left: 50%;
    transform: translateX(-50%);
    background-color: #f8d7da;
    color: #721c24;
    padding: 10px 20px;
    border-radius: 5px;
    display: none;
    z-index: 1000;
}

.notifications.show {
    display: block;
}

.hidden {
    display: none;
}

.fade-in {
    animation: fadeIn 1.5s ease-in-out;
}

@keyframes fadeIn {
    from {
        opacity: 0;
    }
    to {
        opacity: 1;
    }
}

</style>
</body>
</html>
